% 
% This is file `iopconfser.cls'
%
% This file is distributed in the hope that it will be useful, 
% but WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%
% IOP Publishing Ltd
%
% email: customerservices@ioppublishing.org
%
% Copyright 2022 IOP Publishing Ltd.
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.3c
% of this license or (at your option) any later version.
% The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3c or later is part of all distributions of LaTeX
% version 2005/12/01 or later.
% 
% This work has the LPPL maintenance status `maintained'.
% 
% The Current Maintainer of this work is IOP Publishing Ltd.
%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{iopconfser}[2022/11/30 IOP Conference Series LaTeX template]

\LoadClass[a4paper, 11pt]{article}


% Margin settings
\setlength{\hoffset}{0mm}
\setlength{\marginparsep}{0mm}
\setlength{\marginparwidth}{0mm}
\setlength{\textwidth}{160mm}
\setlength{\oddsidemargin}{-0.4mm}
\setlength{\evensidemargin}{-0.4mm}
\setlength{\voffset}{15mm}
\setlength{\headheight}{0mm}
\setlength{\headsep}{0mm}
\setlength{\footskip}{0mm}
\setlength{\textheight}{230mm}
\setlength{\topmargin}{0mm}

% More length definitions
\setlength\maxdepth{.5\topskip}
\setlength\@maxdepth\maxdepth
\setlength\footnotesep{8.4\p@}
\setlength{\skip\footins} {10.8\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep       {14\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\textfloatsep   {24\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep      {16\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\dblfloatsep    {16\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\dbltextfloatsep{24\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@}
\setlength\@fpsep{10\p@ \@plus 1fil}
\setlength\@fpbot{0\p@}
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{10\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@}
\setlength\partopsep{3\p@ \@plus 2\p@ \@minus 2\p@}

% Set indent for front matter
\renewenvironment{quote}%
  {\list{}{\leftmargin=25mm}\item\relax}%
  {\endlist}

% Clear the header and footer

\pagestyle{empty}

% Styles for front matter

\renewcommand{\title}[1]{{\exhyphenpenalty=10000\hyphenpenalty=10000 
 \fontsize{18}{24}\selectfont\bf\noindent\raggedright
        \textsf{#1}\par}}

		
\renewcommand{\author}[1]{\vspace*{1.5pc}%
   \fontsize{11}{13}
       \begin{quote}\raggedright \textbf{#1}\end{quote}}

\newcommand{\affil}[1]{{\fontsize{10}{11}\selectfont
       \begin{quote}\raggedright #1\end{quote}
	   \vspace*{-22pt}}}

\newcommand{\email}[1]{{\vspace*{12pt}\fontsize{10}{11}\selectfont
       \begin{quote}\raggedright E-mail: #1\end{quote}
	   \vspace*{-22pt}}}

\renewenvironment{abstract}{%
      \vspace{16pt plus3pt minus3pt}
	  \begin{quote}
      \bfseries \abstractname.\quad\rm\ignorespaces} 
      {\end{quote}\vspace{5mm}}

% Section titles
	
\renewcommand\section{\@startsection {section}{1}{\z@}%
                   {-3.25ex\@plus -1ex \@minus -.2ex}%
                   {1sp}%
                   {\reset@font\normalsize\bfseries\raggedright}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                   {-3.25ex\@plus -1ex \@minus -.2ex}%
                   {1sp}%
                   {\reset@font\normalsize\itshape\raggedright}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {-1em \@plus .2em}%
                                     {\reset@font\normalsize\itshape}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\reset@font\normalsize\itshape}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\reset@font\normalsize\itshape}}
			



\endinput